const path = require("path");

// WordPress webpack config.
const defaultConfig = require('@wordpress/scripts/config/webpack.config');

// Plugins.
const RemoveEmptyScriptsPlugin = require('webpack-remove-empty-scripts');

module.exports = {
	// Includes the default webpack config from WordPress.
	...defaultConfig,
	...{
		context: path.resolve(__dirname, './src'),
		entry: {
			'js/jsf-listing-app': path.resolve(process.cwd(), 'src', 'index.js'),
			'css/jsf-listing-app': path.resolve(process.cwd(), 'src', 'style.scss'),
			// listing block
			'../../render/assets/js/jsf-listing-block': path.resolve(process.cwd(), 'src', 'blocks', 'listing', 'index.js'),
			// render styles
			'../../render/assets/css/jsf-listing-render': path.resolve(__dirname, '../includes/listing/render/assets/scss/style.scss'),
		},
		output: {
			...defaultConfig.output,
			path: path.resolve(process.cwd(), '../includes/listing/builder/assets'),
			clean: false
		},
		performance: {
			maxAssetSize: 1024 * 5000, //(5 MB)
			maxEntrypointSize: 1024 * 5000, //(5 MB)
		},
		resolve: {
			modules: [
				"node_modules",
			],
			alias: {
				'@': path.resolve(__dirname, 'src'),
				'store': path.resolve(__dirname, 'src/store'),
				'services': path.resolve(__dirname, 'src/services'),
				'modules': path.resolve(__dirname, 'src/modules'),
				'blocks': path.resolve(__dirname, '../includes/listing/builder/blocks')
			},
			extensions: ['.js', '.jsx', '...']
		},
		plugins: [
			...defaultConfig.plugins,

			// Removes the empty `.js` files generated by webpack but
			// sets it after WP has generated its `*.asset.php` file.
			new RemoveEmptyScriptsPlugin({
				ignore: ['js/jsf-listing-app'],
				stage: RemoveEmptyScriptsPlugin.STAGE_AFTER_PROCESS_PLUGINS
			})
		]
	}
};